//=============================================================================
// MarkusPlayer.
//
// Custom player class for the markistan mod's training
//=============================================================================
class MarkistanTroopMale extends MarkusGrayMale; 

function DoJump( optional float F )
{
	local DeusExWeapon w;
	local float scaleFactor, augLevel;

	if ((CarriedDecoration != None) && (CarriedDecoration.Mass > 20))
		return;
	else if (bForceDuck || IsLeaning())
		return;

	if (Physics == PHYS_Walking)
	{
		if ( Role == ROLE_Authority )
			PlaySound(JumpSound, SLOT_None, 1.5, true, 1200, 1.0 - 0.2*FRand() );
		if ( (Level.Game != None) && (Level.Game.Difficulty > 0) )
			MakeNoise(0.1 * Level.Game.Difficulty);
		PlayInAir();

		Velocity.Z = JumpZ;

		if ( Level.NetMode != NM_Standalone )
		{
         if (AugmentationSystem == None)
            augLevel = -1.0;
         else			
            augLevel = AugmentationSystem.GetAugLevelValue(class'AugSpeed');
			w = DeusExWeapon(InHand);
			if ((augLevel != -1.0) && ( w != None ) && ( w.Mass > 30.0))
			{
				scaleFactor = 1.0 - FClamp( ((w.Mass - 30.0)/55.0), 0.0, 0.5 );
				Velocity.Z *= scaleFactor;
			}
		}
		
		// reduce the jump velocity if you are crouching
//		if (bIsCrouching)
//			Velocity.Z *= 0.9;

		if ( Base != Level )
			Velocity.Z += Base.Velocity.Z;
		SetPhysics(PHYS_Falling);
		if ( bCountJumps && (Role == ROLE_Authority) )
			Inventory.OwnerJumped();
	}
}

// ----------------------------------------------------------------------
// TravelPostAccept()
// ----------------------------------------------------------------------

event TravelPostAccept()
{
    local DeusExLevelInfo info;

    local Skill aSkill;
    local int i;

//       Super.TravelPostAccept();
//     MultiSkins(0)=Texture'Markistan.Skins.MarkusTex0'
//     MultiSkins(1)=Texture'Markistan.Skins.MarkusTex2'
//     MultiSkins(3)=Texture'Markistan.Skins.MarkusTex0'
//     MultiSkins(4)=Texture'Markistan.Skins.MarkusTex1'
//     MultiSkins(5)=Texture'Markistan.Skins.MarkusTex2'
	Super(JCDentonMale).TravelPostAccept();

	switch(PlayerSkin)
	{
		case 0:	   	MultiSkins[0] = Texture'DeusExCharacters.Skins.SkinTex1';
     				MultiSkins[1] = Texture'DeusExCharacters.Skins.MJ12TroopTex1';
     				MultiSkins[2] = Texture'Markistan.Skins.MarkistanTroopTex2';
     				MultiSkins[3] = Texture'DeusExCharacters.Skins.SkinTex1';
     				MultiSkins[4] = Texture'DeusExItems.Skins.PinkMaskTex';
     				MultiSkins[5] = Texture'Markistan.Skins.MarkistanTroopTex3';
     				MultiSkins[6] = Texture'Markistan.Skins.MarkistanTroopTex4';
     				MultiSkins[7] = Texture'DeusExItems.Skins.PinkMaskTex';
			break;
		case 1:	   	MultiSkins[0] = Texture'DeusExCharacters.Skins.SkinTex1';
     				MultiSkins[1] = Texture'DeusExCharacters.Skins.MJ12TroopTex1';
     				MultiSkins[2] = Texture'Markistan.Skins.MarkistanTroopTex2';
     				MultiSkins[3] = Texture'DeusExCharacters.Skins.SkinTex1';
     				MultiSkins[4] = Texture'DeusExItems.Skins.PinkMaskTex';
     				MultiSkins[5] = Texture'Markistan.Skins.MarkistanTroopTex3';
     				MultiSkins[6] = Texture'Markistan.Skins.MarkistanTroopTex4';
     				MultiSkins[7] = Texture'DeusExItems.Skins.PinkMaskTex';
			break;
		case 2:	   	MultiSkins[0] = Texture'DeusExCharacters.Skins.SkinTex1';
     				MultiSkins[1] = Texture'DeusExCharacters.Skins.MJ12TroopTex1';
     				MultiSkins[2] = Texture'Markistan.Skins.MarkistanTroopTex2';
     				MultiSkins[3] = Texture'DeusExCharacters.Skins.SkinTex1';
     				MultiSkins[4] = Texture'DeusExItems.Skins.PinkMaskTex';
     				MultiSkins[5] = Texture'Markistan.Skins.MarkistanTroopTex3';
     				MultiSkins[6] = Texture'Markistan.Skins.MarkistanTroopTex4';
     				MultiSkins[7] = Texture'DeusExItems.Skins.PinkMaskTex';
			break;
		case 3:	   	MultiSkins[0] = Texture'DeusExCharacters.Skins.SkinTex1';
     				MultiSkins[1] = Texture'DeusExCharacters.Skins.MJ12TroopTex1';
     				MultiSkins[2] = Texture'Markistan.Skins.MarkistanTroopTex2';
     				MultiSkins[3] = Texture'DeusExCharacters.Skins.SkinTex1';
     				MultiSkins[4] = Texture'DeusExItems.Skins.PinkMaskTex';
     				MultiSkins[5] = Texture'Markistan.Skins.MarkistanTroopTex3';
     				MultiSkins[6] = Texture'Markistan.Skins.MarkistanTroopTex4';
     				MultiSkins[7] = Texture'DeusExItems.Skins.PinkMaskTex';
			break;
		case 4:	   	MultiSkins[0] = Texture'DeusExCharacters.Skins.SkinTex1';
     				MultiSkins[1] = Texture'DeusExCharacters.Skins.MJ12TroopTex1';
     				MultiSkins[2] = Texture'Markistan.Skins.MarkistanTroopTex2';
     				MultiSkins[3] = Texture'DeusExCharacters.Skins.SkinTex1';
     				MultiSkins[4] = Texture'DeusExItems.Skins.PinkMaskTex';
     				MultiSkins[5] = Texture'Markistan.Skins.MarkistanTroopTex3';
     				MultiSkins[6] = Texture'Markistan.Skins.MarkistanTroopTex4';
     				MultiSkins[7] = Texture'DeusExItems.Skins.PinkMaskTex';
			break;
	}
}

defaultproperties
{
     TruePlayerName="Markus Gray"
     SkillPointsTotal=3750
     SkillPointsAvail=3750
     Credits=200
     strStartMap="16_Markistan_1"
     bStartNewGameAfterIntro=True
     CarcassType=Class'Markistan.MarkistanTroopCarcass'
     AccelRate=2048.000000
     FamiliarName="Ralph"
     UnfamiliarName="Markistan Troop"
     Mesh=LodMesh'DeusExCharacters.GM_Jumpsuit'
     MultiSkins(0)=Texture'DeusExCharacters.Skins.SkinTex1'
     MultiSkins(1)=Texture'DeusExCharacters.Skins.MJ12TroopTex1'
     MultiSkins(2)=Texture'Markistan.Skins.MarkistanTroopTex2'
     MultiSkins(3)=Texture'DeusExCharacters.Skins.SkinTex1'
     MultiSkins(4)=Texture'DeusExItems.Skins.PinkMaskTex'
     MultiSkins(5)=Texture'Markistan.Skins.MarkistanTroopTex3'
     MultiSkins(6)=Texture'Markistan.Skins.MarkistanTroopTex4'
     MultiSkins(7)=Texture'DeusExItems.Skins.PinkMaskTex'
     Texture=Texture'DeusExItems.Skins.PinkMaskTex'
}
